function   []=ACQUIRE_FILE_TAIL_PLOT(FileName,PLen,NPlot)
%function   []=ACQUIRE_FILE_TAIL_PLOT(FileName,PLen,NPlot)
%
%  Ian Stothers Apr 2021
setenv('XDG_SESSION_TYPE','x11');
 sf=figure;
 set(sf,'renderermode','manual');
 set(sf,"numbertitle","off");
 set(sf,'name','ACQUIRE_FILE_TAIL_PLOT');
 sb=stopbut(sf,[5  5 100 22],"END PLOT");
 pb=stopbut(sf,[110  5 110 22],"PAUSE PLOT");
 drawnow;
 set(sf,'position',[400 200 600 400]); % must be last window configuring item - don't know why
 if (nargin<1)
   [Fn,Pn]=uigetfile();
   FileName=[Pn Fn];
 endif
 tic;
 while  ((exist(FileName)<1)&&(toc<5))
   pause(.5);
 end
[Data,Time,Meta]=ACQUIRE_FILE_GET(FileName,1,2 );
 if (nargin<2)
   PLen=5/Meta.DeltaT;
   PLen=ceil(PLen/1000)*1000;
 endif
 try
  if (nargin<3)
    NPlot=1;
    dec=0;
  else
    dec=1;
  endif
   tocid=tic;
   tim=toc(tocid);
  while(NPlot>0)

   if(get(pb,"value")==0)
    NPlot=NPlot-dec;
    if (nargin<2)
     PLen=5/Meta.DeltaT;
     PLen=ceil(PLen/1000)*1000;
    endif
    [Data,Time,Meta]=ACQUIRE_FILE_GET(FileName,-1,PLen,Meta);
    if(isfield(Meta,'StartupTransientSamples'))
      Tindx=find(Time>Meta.StartupTransientSamples*Meta.DeltaT);
      Data=Data(:,Tindx);
      Time=Time(:,Tindx);
    end
    ax=[min(Time) max(Time) min(min(Data)) max(max(Data))];
    if (max(size(ax))==4)
     plot(Time,Data');
     axis(ax);
     grid on;
     xlabel("Time (S)");
     ylabel("Volts");
     title(FileName);
     else
     meta=[];
    endif
   endif
   drawnow;
   tim=tim+.3;
   while(tim>toc(tocid))
    pause(0.05);
   end
   if(get(sb,"value")==1) NPlot=0;delete(sf); return; endif
  endwhile
 catch
  delete(sf);
  return;
 end
end

function [pb]=stopbut(f,pos,txt)
 pb=uicontrol(...
 "style","togglebutton",...
 "string",txt,...
 "position",pos);
end

